--war früher ab2__a_iu__termini
DROP TRIGGER IF EXISTS ab2__a_iu__termini ON ab2;
DROP FUNCTION IF EXISTS ab2__a_iu__termini() CASCADE;
-- Trigger ab2__a_iu__termination_manual
-- aus 0200 Tables\J abk.sql
-- übertragen von Terminveränderungen auf Nach&Vorarbeitsgänge
-- Eintragen des Termins in ABK
-- Bei manueller Vorgabe eines Termins AG entsprechend einterminieren
-- Aktualisieren der Terminwoche in Plantafel, wenn Terminänderung
CREATE OR REPLACE FUNCTION ab2__a_iu__termination_manual() RETURNS TRIGGER AS $$
    DECLARE
        _startdate  timestamp;
        _direction  varchar = null;
        _prefix     varchar = format( 'ab2__a_iu__termination_manual ABK %L, AG %L -', new.a2_ab_ix, new.a2_n );
        _start_time time;
        _end_time   time;
        _ag_ids_for_kdatum_refresh integer[];
        _loglevel   integer := TSystem.Log_Get_LogLevel( _user => 'yes' );

    BEGIN --ACHTUNG: nur wenn nicht aus Terminierung kommend! siehe WHEN in Trigger => NOT execution_flag__isset( _flagname => 'inTerminierung' )

      _start_time := clock_timestamp()::time;
      --
      IF _loglevel >= 5 THEN
          RAISE NOTICE '% ENTER:%;', _prefix, _start_time;
      END IF;
      --
      IF (
          new.a2_interm  -- ist einterminiert => Änderung
          OR (new.a2_at IS NOT null AND new.a2_et IS null OR new.a2_at IS null AND new.a2_et IS NOT null) -- ist NICHT einterminiert, aber ein Datum wurde angegeben!
          )
      THEN -- BEACHTE >> WHEN (NOT new.a2_ende) <<
          -- vorwärts oder rückwärts. wenn anfang oder dlz verändert, dann vorwärts sonst rückwärts
          -- a2_interm wird im Trigger automatisch (nur dann) true, wenn beide Datum gesetzt!
          IF   (new.a2_at  IS DISTINCT FROM old.a2_at)
            OR (new.a2_dlz IS DISTINCT FROM old.a2_dlz)
            OR (new.a2_ende IS DISTINCT FROM old.a2_ende) -- AG wieder geöffnet
          THEN
              _startdate := new.a2_at;
              _direction := 'forward';
          ELSIF
          -- Rückwärts terminieren
              (new.a2_et  IS DISTINCT FROM old.a2_et)
          THEN
              _startdate := new.a2_et;
              _direction := 'backward';
          END IF;

          PERFORM scheduling.abk__termination_execute__auto(new.a2_ab_ix,
                                        _a2_n__middle => null::int,
                                        -- _current_date                             timestamp    DEFAULT now() ?? > Vergangenheit ermöglichen?
                                        _date_start => _startdate,
                                        _write_to_disk => true,
                                        _forward__backward__middle__null_auto => _direction,
                                        _a2_n__start => new.a2_n,
                                        _a2_n__stop => new.a2_n,
                                        _dlz_terminiation => true,
                                        _allow_overlap => true,
                                        _loglevel => _loglevel
                                        );
      ELSIF tg_op = 'UPDATE' AND NOT new.a2_interm THEN
      -- Manuelles Austerminieren über a2_at und a2_et auf null setzen in resource_timeline überführen
          DELETE FROM scheduling.resource_timeline WHERE ti_a2_id = new.a2_id;
      END IF;


      -- Übergabe Bedarfstermine an auftg. Nur konkret auf AG Ebene!
      IF tg_op = 'UPDATE' THEN
              -- wenn AG-Termin sich geändert hat
              IF new.a2_at IS DISTINCT FROM old.a2_at THEN
                  -- Termine bei verlinkten Materialien aktualisieren, siehe #13842
                  _ag_ids_for_kdatum_refresh :=
                        array_agg( ag_id )
                      FROM auftg
                      WHERE ag_a2_id = new.a2_id
                  ;
                  IF _ag_ids_for_kdatum_refresh IS NOT NULL THEN
                      PERFORM tabk.abk__auftgi_kldatum__refresh( _ag_ids_for_kdatum_refresh );
                  END IF;
              END IF;
      END IF;

      --
      _end_time := clock_timestamp()::time;
      --
      IF _loglevel >= 5 THEN
          RAISE NOTICE '% Duration:%, Start:%, Leave:%', _prefix, _end_time - _start_time, _start_time, _end_time;
      END IF;

      RETURN new;

    END $$ LANGUAGE plpgsql;
--
  DROP TRIGGER IF EXISTS ab2__a_iu__termination_manual ON ab2;
  CREATE TRIGGER ab2__a_iu__termination_manual
      AFTER INSERT OR UPDATE
      OF a2_at, a2_et, a2_dlz, a2_ende/*AG wieder geöffnet*/--, a2_lgz =>
      ON ab2
      FOR EACH ROW
      WHEN (NOT (   new.a2_ende
                OR TSystem.execution_flag__isset__cascade_save( _flagname => 'inTerminierung' )
                OR TSystem.execution_flag__isset__cascade_save( _flagname => 'in_ab2__at_et__from__resource_timeline__sync' )
                ) --damit nicht 100 mal autfg durch veränderung von ET im ABK während Terminierung
      )
      EXECUTE PROCEDURE ab2__a_iu__termination_manual();
--